/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpCommon.GraphDefinition;
import ibm.nways.analysis.dpCommon.SortedStringVector;
import ibm.nways.analysis.dpCommon.ViewDefinition;
import ibm.nways.analysis.dpManager.Admin.BasicConfigPanel;
import ibm.nways.analysis.dpManager.Admin.DpAdminPanel;
import ibm.nways.analysis.dpManager.Admin.IdSelector;
import ibm.nways.analysis.dpManager.VectorUtil;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.nhm.eui.AccumulatorBox;
import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;

public class Views
extends BasicConfigPanel
implements ItemListener,
JCItemListener,
JCActionListener {
    private DpAdminPanel adminPanel;
    private IdSelector viewID;
    private Choice timeUnits;
    private String previous;
    private AccumulatorBox graphDefBox;
    private Vector graphCurrentlyAssociated;
    private NumericInput numericSelection;
    private boolean timeUnitsInitializing = false;
    private Checkbox allCheck;
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String NEW_BUTTON_LABEL = adminRB.getString("s_New");
    private static final String DELETE_BUTTON_LABEL = adminRB.getString("s_Delete");
    private static final String ADD_STRING = adminRB.getString("s_Add");
    private static final String REMOVE_STRING = adminRB.getString("s_Remove");
    private static final String EDIT_STRING = adminRB.getString("s_Edit");
    private static final String LOADED_GRAPH_NAMES = adminRB.getString("s_LoadedGraphNames");
    private static final String APPLIED_GRAPH_NAMES = adminRB.getString("s_AppliedGraphNames");
    private static final String TIME_LABEL = adminRB.getString("s_TimeLabel");
    private static final String MINUTES = adminRB.getString("s_Minutes");
    private static final String HOURS = adminRB.getString("s_Hours");
    private static final String DAYS = adminRB.getString("s_Days");
    private static final String WEEKS = adminRB.getString("s_Weeks");
    private static final String MONTHS = adminRB.getString("s_Months");
    private static final String YEARS = adminRB.getString("s_Years");
    private static final String ALL = adminRB.getString("s_All");
    private static final String VIEW_ID_LABEL = adminRB.getString("s_ViewLabel");

    public Views(DpAdminPanel dpAdminPanel, Applet applet) {
        super(applet);
        this.adminPanel = dpAdminPanel;
        this.viewID = new IdSelector(VIEW_ID_LABEL, true);
        this.add("North", this.viewID);
        this.viewID.addActionListener(this);
        this.viewID.addItemListener(this);
        Panel panel = new Panel(new FlowLayout(1));
        Label label = new Label(TIME_LABEL);
        this.numericSelection = new NumericInput(3);
        this.numericSelection.setMinMax(0, Integer.MAX_VALUE);
        this.timeUnits = new Choice();
        this.timeUnits.addItemListener(this);
        this.timeUnits.add(MINUTES);
        this.timeUnits.add(HOURS);
        this.timeUnits.add(DAYS);
        this.timeUnits.add(WEEKS);
        this.timeUnits.add(YEARS);
        Panel panel2 = new Panel(new ColumnLayout(20));
        Panel panel3 = new Panel(new FlowLayout(1));
        this.allCheck = new Checkbox(ALL);
        panel3.add(this.allCheck);
        this.allCheck.addItemListener(this);
        panel.add(label);
        panel.add(this.numericSelection);
        panel.add(this.timeUnits);
        this.graphDefBox = new AccumulatorBox(new Vector(), new Vector(), 5, LOADED_GRAPH_NAMES, APPLIED_GRAPH_NAMES, ADD_STRING, REMOVE_STRING, EDIT_STRING, 200, 125);
        this.graphDefBox.addItemListener(this);
        panel2.add(panel);
        panel2.add(panel3);
        Panel panel4 = new Panel(new ColumnLayout(20));
        panel4.add(panel2);
        panel4.add(this.graphDefBox);
        this.add("Center", panel4);
    }

    public static String toString(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = MINUTES;
                break;
            }
            case 2: {
                string = HOURS;
                break;
            }
            case 3: {
                string = DAYS;
                break;
            }
            case 4: {
                string = WEEKS;
                break;
            }
            case 6: {
                string = YEARS;
                break;
            }
            case 0: {
                string = null;
            }
        }
        return string;
    }

    public static int toUnits(String string) {
        int n = 0;
        if (MINUTES.equals(string)) {
            n = 1;
        } else if (HOURS.equals(string)) {
            n = 2;
        } else if (DAYS.equals(string)) {
            n = 3;
        } else if (WEEKS.equals(string)) {
            n = 4;
        } else if (YEARS.equals(string)) {
            n = 6;
        }
        return n;
    }

    protected void populate() {
        String string = null;
        if (this.viewID.getSelectedItem() != null) {
            string = this.viewID.getSelectedItem();
        }
        Vector vector = null;
        try {
            vector = this.adminPanel.getClientApplet().getViewNamesList();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (vector != null) {
            this.viewID.removeAllIds();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.viewID.addId((String)enumeration.nextElement());
            }
            if (this.viewID.getItemCount() > 0) {
                if (string == null || string.length() == 0) {
                    string = this.viewID.getItem(0);
                }
                this.selectItem(string);
            }
        }
    }

    protected void save() {
        if (this.isDirty()) {
            Vector vector = VectorUtil.stringsToVector(this.graphDefBox.getRightListItems());
            Vector vector2 = VectorUtil.findAdditions(this.graphCurrentlyAssociated, vector);
            Vector vector3 = VectorUtil.findDeletions(this.graphCurrentlyAssociated, vector);
            this.graphCurrentlyAssociated = vector;
            try {
                if (this.adminPanel.getClientApplet().getViewDefinition(this.viewID.getSelectedItem()) == null) {
                    ViewDefinition viewDefinition = new ViewDefinition(this.viewID.getSelectedItem());
                    if (this.allCheck.getState()) {
                        viewDefinition.setPeriodEnding(0L, 0);
                    } else {
                        viewDefinition.setPeriodEnding(this.numericSelection.numericValue(), Views.toUnits(this.timeUnits.getSelectedItem()));
                    }
                    if (vector2 != null) {
                        viewDefinition.setGraphs(vector2);
                    }
                    this.adminPanel.getClientApplet().addViewDefinition(viewDefinition);
                    this.viewID.addId(this.viewID.getSelectedItem());
                    this.viewID.select(this.viewID.getSelectedItem());
                } else if (this.allCheck.getState()) {
                    this.adminPanel.getClientApplet().modifyViewDefinition(this.viewID.getSelectedItem(), vector2, vector3, 0L, 0);
                } else {
                    this.adminPanel.getClientApplet().modifyViewDefinition(this.viewID.getSelectedItem(), vector2, vector3, this.numericSelection.numericValue(), Views.toUnits(this.timeUnits.getSelectedItem()));
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            this.setDirty(false);
        }
    }

    protected void cancel() {
        if (this.previous != null) {
            this.selectItem(this.previous);
        } else if (this.viewID.getItemCount() > 0) {
            if (this.viewID.getSelectedIndex() < 0) {
                this.viewID.select(0);
            }
            this.displayViewInfo(this.viewID.getSelectedItem());
        }
        this.setDirty(false);
    }

    public void selectItem(String string) {
        this.viewID.select(string);
        this.displayViewInfo(this.viewID.getSelectedItem());
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.viewID && jCActionEvent.getActionCommand().equals(NEW_BUTTON_LABEL)) {
            String string = this.viewID.getSelectedItem();
            boolean bl = false;
            Vector vector = null;
            try {
                vector = this.adminPanel.getClientApplet().getViewNamesList();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.selectItem(string);
                return;
            }
            this.displayViewInfo(this.viewID.getSelectedItem());
            this.setDirty(true);
            return;
        }
        if (jCActionEvent.getSource() == this.viewID && jCActionEvent.getActionCommand().equals(DELETE_BUTTON_LABEL)) {
            String string = null;
            try {
                string = this.adminPanel.getClientApplet().removeViewDefinition(this.viewID.getSelectedItem());
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            if (string == null) {
                int n = this.viewID.getSelectedIndex();
                this.viewID.removeId(this.viewID.getSelectedItem());
                if (n > 0 && this.viewID.getItemCount() > n) {
                    this.viewID.select(n);
                    return;
                }
                if (this.viewID.getItemCount() > 0) {
                    this.viewID.select(0);
                    return;
                }
                this.displayViewInfo("");
                return;
            }
            String string3 = String.valueOf(adminRB.getString("s_MsgViewDeleteFailure")) + string;
            new MessageBox(this.getParentFrame(), adminRB.getString("s_MsgDeleteFail"), string3, true);
            return;
        }
        super.actionPerformed(jCActionEvent);
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() == this.graphDefBox) {
            if (jCItemEvent.getStateChange() == 1) {
                this.adminPanel.setPage(adminRB.getString("s_GraphCfg"));
                this.adminPanel.getGraphs().selectItem(jCItemEvent.getItem().toString());
                return;
            }
            if ((jCItemEvent.getStateChange() & 0xC00) != 0) {
                this.setDirty(true);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.viewID && itemEvent.getStateChange() == 1) {
            this.previous = (String)itemEvent.getItem();
            this.displayViewInfo((String)itemEvent.getItem());
            return;
        }
        if (itemEvent.getSource() == this.timeUnits) {
            this.setDirty(true);
            return;
        }
        if (itemEvent.getSource() == this.allCheck) {
            System.out.println("all check activity");
            if (this.allCheck.getState()) {
                System.out.println("state is true");
                this.numericSelection.setEditable(false);
                this.timeUnits.setEnabled(false);
            } else {
                System.out.println("state is false");
                this.numericSelection.setEditable(true);
                this.timeUnits.setEnabled(true);
            }
            this.setDirty(true);
        }
    }

    protected void displayViewInfo(String string) {
        ViewDefinition viewDefinition = null;
        Vector vector = null;
        try {
            vector = this.adminPanel.getClientApplet().getGraphNamesList();
            viewDefinition = this.adminPanel.getClientApplet().getViewDefinition(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        Vector vector2 = null;
        SortedStringVector sortedStringVector = null;
        if (viewDefinition != null) {
            sortedStringVector = new SortedStringVector();
            Enumeration enumeration = viewDefinition.getGraphs().elements();
            while (enumeration != null && enumeration.hasMoreElements()) {
                sortedStringVector.addString(((GraphDefinition)enumeration.nextElement()).getGraphName());
            }
            vector2 = VectorUtil.diffOfTwoVectors(vector, sortedStringVector);
            this.timeUnitsInitializing = true;
            if (viewDefinition.getPeriodEndingUnits() != 0) {
                this.allCheck.setState(false);
                this.numericSelection.setEditable(true);
                this.timeUnits.setEnabled(true);
                this.numericSelection.setValue(Long.toString(viewDefinition.getPeriodEndingNumber()));
                this.timeUnits.select(Views.toString(viewDefinition.getPeriodEndingUnits()));
            } else {
                this.numericSelection.setEditable(false);
                this.timeUnits.setEnabled(false);
                this.allCheck.setState(true);
            }
            this.setDirty(false);
        } else {
            vector2 = vector;
            sortedStringVector = null;
            this.setDirty(true);
        }
        this.graphCurrentlyAssociated = sortedStringVector;
        this.graphDefBox.setLeftList(vector2);
        this.graphDefBox.setRightList(sortedStringVector);
        this.graphDefBox.reset();
    }
}

